#version 150
#extension GL_EXT_gpu_shader4 : enable
///////////////////////////////////////////////////////////////////////////////////////////////////
// iStripper wrapper for Shadertoy conversions by @Calgon  //
///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Notes
//
// Idea was to create a standard wrapper around Shadertoy code that could be applied to any shader
// sourced from Shadertoy.
// Version number is 150 as standard but where later functions are found this is changed to 330

// Wrapper Follows....
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Declare the missing thingamies that aren't available on VGHD
uniform vec3  iChannelResolution[4];	// BUT WE NEED TO FILL THEM !
uniform float iChannelTime[4];

//#define iResolution u_WindowSize
#define iResolution vec3(u_WindowSize, 0)	// Because Shadertoy iResolution is a vec3
#define iFrame 0


//Slow the time functions down a little as standard
//#define iTime u_Elapsed * .5
float iTime;

#define iGlobalTime u_Elapsed * .5

// Seems the word texture is important and should not be replaced.  Therefore we must replace
// Shadertoy texture0..3 with texture 0..3 further down
uniform sampler2D texture0; //Random Surfaces
uniform sampler2D texture1; //Water
uniform sampler2D texture2; //Random Greys
uniform sampler2D texture3; //More surfaces

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture(sampler,fract(P),Bias);}

#define texture texture2D_Fract	// So whenever Shadertoy says "texture" we run it through this Macro
// Can we do the same for Cubemaps 

#define iChannel0 texture0
#define iChannel1 texture1
#define iChannel2 texture2
#define iChannel3 texture3

// Mouse Simulation from @TheEmu	
#define iMouse vec4(0.)
// Alternative Macro if iMouse is better moving
//#define iMouse AUTO_MOUSE  //vec4(0.0,0.0,0.0,0.0)
// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.
#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
//#define MOUSE_POS vec2((0.25+sin(iTime*MOUSE_SPEED*2))*u_WindowSize/2.0)
//#define MOUSE_POS vec2((sin(iTime*1)*.5*u_WindowSize.x/2.0),1.0*u_WindowSize.y/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
#define MOUSE_PRESS vec2(1.0,1.0)
#define AUTO_MOUSE vec4( MOUSE_POS, MOUSE_PRESS )



vec4 iDate;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Uniforms to control timing of each shader
//uniform float cycle_time;
uniform float bgnum;
uniform float maxbgnum;
uniform float rhs;

//uniform float alpha_off;
//uniform float alpha_on;
//uniform float alpha_always_on;
uniform float scene_duration;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Extract a pixel from texture1 to get the random number
float randNum = texture(texture3, vec2(0.0, 0.0)).a;
float seed_start = 3*randNum-1.5;



///////////////////////////////////////////////////////////////////////////////////////////////////
// Shadertoy Code follows
///////////////////////////////////////////////////////////////////////////////////////////////////

// Sourced from https://www.shadertoy.com/view/MdBSDt

// Created by Vinicius Graciano Santos - vgs/2014
// This shader needs some serious work on collision avoidance :D
// http://viniciusgraciano.com/blog/making-of-bacterium/

#define STEPS 64
#define EPS 0.002
#define FAR 18.0
#define PI 3.14159265359

float smin(float a, float b, float k) {
    float h = clamp(.5+.5*(b-a)/k, 0.0, 1.0 );
    return mix(b,a,h)-k*h*(1.-h);
}

vec2 rep(vec2 p) {
    float a = atan(p.y, p.x);
    a = mod(a, 2.0*PI/18.) - PI/18.;
    return length(p)*vec2(cos(a), sin(a));
}

float spikedBall(vec3 p) {
    p = mod(p, 8.0) - 4.0;
    float d = length(p) - 1.2;
    p.xz = rep(p.xz); p.xy = rep(p.xy); 
    return smin(d, length(p.yz)-.1+abs(.15*(p.x-1.0)), 0.1);
}

float capsules(vec3 p) {
    vec3 q = floor(p/4.0);
    p = mod(p, 4.0) - 2.0;
    p.yz = p.yz*cos(iTime + q.z) + vec2(-p.z, p.y)*sin(iTime + q.z);
    p.xy = p.xy*cos(iTime + q.x) + vec2(-p.y, p.x)*sin(iTime + q.x);
    p.zx = p.zx*cos(iTime + q.y) + vec2(-p.x, p.z)*sin(iTime + q.y);
    
    float angle = .3*cos(iTime)*p.x;
    p.xy = cos(angle)*p.xy + sin(angle)*vec2(-p.y, p.x); p.x += 1.0; 
    float k = clamp(2.0*p.x/4.0, 0.0, 1.0); p.x -= 2.*k;
    return length(p) - .5;
}

float map(vec3 p) {   
   return min(spikedBall(p), capsules(p));
}

vec3 normal(vec3 p) {
    vec2 q = vec2(0.0, EPS);
    return normalize(vec3(map(p + q.yxx) - map(p - q.yxx),
                          map(p + q.xyx) - map(p - q.xyx),
                          map(p + q.xxy) - map(p - q.xxy)));
}

float cubeMap(vec3 p, vec3 n) {
    float a = texture(iChannel0, p.yz).r;
    float b = texture(iChannel0, p.xz).r;
    float c = texture(iChannel0, p.xy).r;
    n = abs(n);
    return (a*n.x + b*n.y + c*n.z)/(n.x+n.y+n.z);   
}

vec3 bumpMap(vec3 p, vec3 n, float c) {
    vec2 q = vec2(0.0, .5);
	vec3 grad = -1.0*(vec3(cubeMap(p+q.yxx, n), cubeMap(p+q.xyx, n), cubeMap(p+q.xxy, n))-c)/q.y;
    vec3 t = grad - n*dot(grad, n);
    return normalize(n - t);
}

vec3 shade(vec3 ro, vec3 rd, float t) {
    vec3 p = ro + t*rd, n = normal(p);
   
    vec3 green = pow(vec3(93,202,49)/255., vec3(2.2));
    vec3 yellow = pow(vec3(255,204,0)/255., vec3(2.2));
    
    float k = cubeMap(.5*p, n);
    n = bumpMap(.5*p, n, k);
    
    vec3 col = mix(green, yellow, k)*(1.0-dot(-rd,n));
    if (spikedBall(p) < capsules(p)) {
    	p = mod(p, 8.0) - 4.0;
        col *= 1.0/(1.0 + .5*dot(p, p));
    }
        
    return col*exp(-.008*t*t);
}

mat3 lookat(vec3 p, vec3 t) {
    vec3 z = normalize(p - t);
    vec3 x = cross(z, vec3(0.0, 1.0, 0.0));
    return mat3(x, cross(x, z), z);
}

void mainImage( out vec4 fragColor, in vec2 fragCoord ) {
	vec2 uv = (-iResolution.xy + 2.0*fragCoord.xy) / iResolution.y;
    uv *= 1.0 + .1*dot(uv,uv);
    
	float rox = 0;
	if (rhs == 1){
		rox = 0.1;

	}
	
	
    vec3 ro = vec3(iTime+rox, iTime, cos(iTime));
    vec3 rd = normalize(lookat(ro, ro+vec3(cos(.1*iTime), sin(.1*iTime), 1.0))*vec3(uv, -1.0)); // direÃ§Ã£o do raio.
    
    // based on eiffie's antialiasing method (https://www.shadertoy.com/view/XsSXDt)
    vec3 col = vec3(0.0);
    vec4 stack = vec4(-1.0); bool grab = true;
    float t = 0.0, d = EPS, od = d, pix = 4.0/iResolution.x, w = 1.8, s = 0.0;
    for (int i = 0; i < STEPS; ++i) {
        d = map(ro + t*rd);
        if (w > 1.0 && (od + d < s)) {
            s -= w*s; w = 1.0;
        } else {
            s = d * w;   
        	if (d <= od) grab = true;
        	else if (grab && stack.w < 0. && od < pix*(t-od)) {
            	stack.w = t-od; stack = stack.wxyz; 
            	grab = false;
        	}
        	if (d < EPS || t > FAR) break;
        }
        od = d; t += s; 
    }
    col = d < EPS ? shade(ro, rd, t) : col;
    
    for (int i = 0; i < 4; ++i) {
        if (stack[i] < 0.0) break;
        d = map(ro + stack[i]*rd);
        col = mix(shade(ro, rd, stack[i]), col, clamp(d/(pix*stack[i]), 0.0, 1.0));
    }
    
    col = smoothstep(0., .7, col);
    col = pow(col, vec3(1.0/2.2));
    
	fragColor = vec4(col,1.0);
}


///////////////////////////////////////////////////////////////////////
// Shadertoy footer wrapper
///////////////////////////////////////////////////////////////////////

void main ( void )
{
	float alpha_on;
	float alpha_off;
	float timer_reset = 1200;
	

	float start_scene_num = randNum * maxbgnum;
	start_scene_num = int(start_scene_num) + 0.;
	
	float show_duration = maxbgnum * scene_duration;
	


	int primeNumbers[] = int[](
    2, 3, 4, 5, 6, 7, 11, 13, 17, 19, 23, 29, 31, 37,
    41, 43, 53, 59, 61, 67, 71, 73, 79,
    83, 89, 97, 101, 103, 107, 109, 113, 127, 131,
    137, 139, 149, 151, 157, 163, 167, 173, 179, 181,
    191, 193, 197, 199, 211, 223, 227, 229, 233, 239,
    241, 251, 257, 263, 269, 271, 277, 281, 283, 293,
    307, 311, 313, 317, 331, 337, 347, 349, 353, 359,
    367, 373, 379, 383, 389, 397, 401, 409, 419, 421,
    431, 433, 439, 443, 449, 457, 461, 463, 467, 479,
    487, 491, 499, 503, 509, 521, 523, 541, 547, 557,
    563, 569, 571, 577, 587, 593, 599, 601, 607, 613,
    617, 619, 631, 641, 643, 647, 653, 659, 661, 673,
    677, 683, 691, 701, 709, 719, 727, 733, 739, 743,
    751, 757, 761, 769, 773, 787, 797, 809, 811, 821,
    823, 827, 829, 839, 853, 857, 859, 863, 877, 881,
    883, 887, 907, 911, 919, 929, 937, 941, 947, 953,
    967, 971, 977, 983, 991, 997, 1009, 1013, 1019, 1021,
    1031, 1033, 1039, 1049, 1051, 1061, 1063, 1069, 1087, 1091,
    1093, 1097, 1103, 1109, 1117, 1123, 1129, 1151, 1153, 1163,
    1171, 1181, 1187, 1193, 1201, 1213, 1217, 1223, 1229, 1231,
    1237, 1249, 1259, 1277, 1279, 1283, 1289, 1297, 1301, 1303,
    1307, 1319, 1321, 1327, 1361, 1367, 1373, 1381, 1399, 1409,
    1423, 1427, 1429, 1433, 1439, 1447, 1451, 1453, 1459, 1471,
    1481, 1483, 1487, 1489, 1493, 1499, 1511, 1529, 1531, 1543,
    1549, 1553, 1559, 1567, 1571, 1579, 1583, 1597, 1601, 1607,
    1609, 1613, 1619, 1621, 1627, 1637, 1657, 1663, 1667, 1669,
    1693, 1697, 1699, 1709, 1721, 1723, 1733, 1741, 1747, 1753,
    1759, 1777, 1783, 1787, 1789, 1801, 1811, 1823, 1831, 1847,
    1861, 1867, 1871, 1873, 1877, 1879, 1889, 1901, 1907, 1913,
    1931, 1933, 1949, 1951, 1973, 1979, 1987, 1993
);

	float my_cycle_time = maxbgnum * scene_duration;
	float my_part_cycle = my_cycle_time * fract(u_Elapsed / my_cycle_time);
	float scene_num = int((my_part_cycle ) / scene_duration) + 1. ;
	
	
	float rand32 = floor(randNum * 256) + 1;
	
	float rand_start = floor(randNum * maxbgnum) + 1;
	
	
	
	float cycle_number = floor(u_Elapsed / my_cycle_time) + 1.;
	float last_cycle_number = floor((u_Elapsed-scene_duration) / my_cycle_time) +1.;
	float next_cycle_number = floor((u_Elapsed+scene_duration) / my_cycle_time) +1.;
	
	
	int interval 		= primeNumbers[int(rand32 - 1 +cycle_number -1)];
	
//	interval 		= primeNumbers[int(rand32 - 1)];
	
	
	int last_interval   = primeNumbers[int(rand32 - 1 +last_cycle_number -1)];
	int next_interval   = primeNumbers[int(rand32 - 1 +next_cycle_number -1)];

	float product = scene_num * interval;

//	float run_scene_num = floor(u_Elapsed / scene_duration) + 1.;


//	float actual = floor(maxbgnum* fract(scene_num * interval/maxbgnum) + 0.1) ;	// Add .1 so we always knock down to whole integer

//	float last = floor(maxbgnum* fract((scene_num - 1.) * last_interval/maxbgnum) + 0.1);
//	float next = floor(maxbgnum* fract((scene_num + 1.) * next_interval/maxbgnum) + 0.1);
	
	float actual = floor(maxbgnum* fract((rand_start + scene_num * interval)/maxbgnum) + 0.1) ;	// Add .1 so we always knock down to whole integer
	float last = floor(maxbgnum* fract((rand_start+(scene_num - 1.) * last_interval)/maxbgnum) + 0.1);
	float next = floor(maxbgnum* fract((rand_start+(scene_num + 1.) * next_interval)/maxbgnum) + 0.1);
	
	
	
	
	
	if (actual == 0){
		actual = maxbgnum;
	}

	
	if (next == 0){
		next = maxbgnum;
	}
	
	
	
	
	if (bgnum > 0){
		
		if (bgnum == actual){
			alpha_on = floor(u_Elapsed/scene_duration) * scene_duration;
			alpha_off = alpha_on + scene_duration;
		
		}
		
		
		
	}
	
	// If next is higher than actual, it should be on 1 second before it becomes actual
	
	float faded_alpha = 1.;
	
	if (next > actual){
		if (bgnum == next){
				//alpha_on 	= floor(u_Elapsed/scene_duration) * scene_duration + scene_duration - 1.;
				//alpha_off 	= floor(u_Elapsed/scene_duration) * scene_duration;  // Off at end of scene
				alpha_on = floor(u_Elapsed/scene_duration) * scene_duration + scene_duration - 1.;
				alpha_off = alpha_on + 1.;
				
				

		}
		if (bgnum == actual){
			faded_alpha = alpha_off - u_Elapsed;
		}
	}
	
	// Here next needs to start appearing before it becomes actual
	if (next < actual){
		if (bgnum == next){
			alpha_on = floor(u_Elapsed/scene_duration) * scene_duration + scene_duration - 1.;
			alpha_off = alpha_on + 1.;
			faded_alpha = u_Elapsed + 1. - alpha_off;
		}
		// And actual needs to not fade
	}
	
	
	
	
	

	
	
	

	iTime = u_Elapsed * .5;


	if (iTime > timer_reset){
		iTime = timer_reset * fract(iTime / timer_reset);
	}
	float cycle_time = maxbgnum * scene_duration;
	float cycles = (u_Elapsed)/cycle_time;
	float full_cycles = trunc(cycles);
    float part_cycles = u_Elapsed - (full_cycles * cycle_time);
	
	vec4 blank = vec4(0.);
	
	// Run the full program only at the right time..
	//if ((part_cycles > alpha_on-1.)&&(part_cycles <= alpha_off+1.)){
	if ((u_Elapsed >= alpha_on)&&(u_Elapsed <= alpha_off)){
		mainImage ( gl_FragColor, gl_FragCoord.xy );
		gl_FragColor.a = 1.0;
		gl_FragColor.a = faded_alpha;
		
		
		
	}
	// Otherwise... just blank => massive performance boost
	else{
		gl_FragColor = blank;		
    }
	
	
	// Fase alpha if next is larger
	
	
	
	
	
	
	
	
	
	
	
	

}


